/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.panes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import net.ftb.data.Settings;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.panes.ILauncherPane;
import net.ftb.log.Logger;
import net.ftb.util.OSUtils;

public class NewsPane
extends JPanel
implements ILauncherPane {
    private JEditorPane news;
    private JScrollPane newsPanel;
    private final HTMLEditorKit news_kit = new HTMLEditorKit();

    public NewsPane() {
        if (OSUtils.getCurrentOS() == OSUtils.OS.WINDOWS) {
            this.setBorder(new EmptyBorder(-5, -25, -5, 12));
        } else {
            this.setBorder(new EmptyBorder(-4, -25, -4, -2));
        }
        this.setLayout(new BorderLayout());
        this.news = new JEditorPane();
        this.news.setEditable(false);
        this.news.setEditorKit(this.news_kit);
        this.news.setContentType("text/html");
        this.news.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    OSUtils.browse(e.getURL().toString());
                }
            }
        });
        this.newsPanel = new JScrollPane(this.news);
        this.newsPanel.setHorizontalScrollBarPolicy(31);
        this.newsPanel.setVerticalScrollBarPolicy(22);
        this.add((Component)this.newsPanel, "Center");
    }

    @Override
    public void onVisible() {
        try {
            this.news.setPage("http://launcher.feed-the-beast.com/news.php");
            Settings.getSettings().setNewsDate();
            Settings.getSettings().save();
            LaunchFrame.getInstance().setNewsIcon();
        }
        catch (IOException e1) {
            Logger.logError("Error while updating news tab", e1);
        }
    }
}

